namespace Microsoft.Samples.PlanMyNight.Infrastructure.Tests
{
    using System.ComponentModel.Composition;
    using System.ComponentModel.Composition.Hosting;
    using System.Linq;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.Infrastructure;
    using Microsoft.Samples.PlanMyNight.Infrastructure.Mvc;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class AddinsHelperFixture
    {
        [TestMethod]
        public void ShouldReturnRouteValueExportsWithExtensionSiteMetadata()
        {
            var container = new CompositionContainer(new TypeCatalog(typeof(MockActionExport)));
            ServiceLocator.SetLocatorProvider(() => container);

            var actual = AddinExtensions.GetActionsFor(MockActionExport.TargetSite, null).ToList();

            Assert.AreEqual(1, actual.Count);
            Assert.AreSame(MockActionExport.ExportedRouteValueDictionary, actual[0]);
        }

        [TestMethod]
        public void ShouldNotReturnRouteValueExportsForOtherTargetSites()
        {
            var container = new CompositionContainer(new TypeCatalog(typeof(MockActionExport)));
            ServiceLocator.SetLocatorProvider(() => container);

            var actual = AddinExtensions.GetActionsFor("InexistantTarget", null).ToList();

            Assert.AreEqual(0, actual.Count);
        }

        [TestMethod]
        public void ShouldReturnExtensionLinkExportsWithExtensionSiteMetadata()
        {
            var container = new CompositionContainer(new TypeCatalog(typeof(MockActionExport)));
            ServiceLocator.SetLocatorProvider(() => container);

            var actual = AddinExtensions.GetLinksFor(MockActionExport.TargetSite, null).ToList();

            Assert.AreEqual(1, actual.Count);
            Assert.AreSame(MockActionExport.ExportedExtensionLink, actual[0]);
        }

        [TestMethod]
        public void ShouldNotReturnExtensionLinkExportsForOtherTargetSites()
        {
            var container = new CompositionContainer(new TypeCatalog(typeof(MockActionExport)));
            ServiceLocator.SetLocatorProvider(() => container);

            var actual = AddinExtensions.GetLinksFor("InexistantTarget", null).ToList();

            Assert.AreEqual(0, actual.Count);
        }

        internal class MockActionExport
        {
            public const string TargetSite = "MyTargetSite";
            public static readonly RouteValueDictionary ExportedRouteValueDictionary = new RouteValueDictionary(new { controller = "MyTargetSite" });
            public static readonly ExtensionLink ExportedExtensionLink = new ExtensionLink() { LinkText = "Text" };

            [Export(typeof(RouteValueDictionary))]
            [ExtensionSiteMetadata(TargetExtensionSite = TargetSite)]
            public RouteValueDictionary EmailToolboxExport
            {
                get
                {
                    return ExportedRouteValueDictionary;
                }
            }

            [Export(typeof(ExtensionLink))]
            [ExtensionSiteMetadata(TargetExtensionSite = TargetSite)]
            public ExtensionLink EmailLinkExport
            {
                get
                {
                    return ExportedExtensionLink;
                }
            }
        }
    }
}
